/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.datasync.content;

import dev.upcraft.datasync.DataSyncMod;
import dev.upcraft.datasync.api.DataSyncAPI;
import dev.upcraft.datasync.content.DataType;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.Nullable;

public class StoredDataHolder<T> {
    private final Object loadingLock = new Object();
    private final DataType<T> type;
    private final UUID playerId;
    private Instant lastUpdated = Instant.MIN;
    @Nullable
    private T value;
    private CompletableFuture<T> loaderFuture;

    private StoredDataHolder(DataType<T> type, UUID playerId) {
        this.type = type;
        this.playerId = playerId;
    }

    private StoredDataHolder(DataType<T> type, UUID playerId, T value) {
        this(type, playerId);
        this.setValue(value);
    }

    public void reload() {
        T previous = this.value;
        if (this.loaderFuture != null) {
            this.loaderFuture.cancel(true);
        }
        this.loaderFuture = ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            try {
                return this.type.fetchRemote(this.playerId);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getCause());
            }
        }).exceptionally(t -> {
            DataSyncMod.LOGGER.error("Unable to fetch data for {}[{}]", new Object[]{this.type.id(), this.playerId, t});
            return previous;
        })).thenApplyAsync(this::onLoadComplete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T onLoadComplete(T value) {
        Object object = this.loadingLock;
        synchronized (object) {
            if (!this.isLoading()) {
                return this.value;
            }
            this.value = value;
            this.lastUpdated = Instant.now();
            this.loaderFuture = null;
        }
        return value;
    }

    public boolean isLoading() {
        return this.loaderFuture != null;
    }

    public T value() {
        this.checkExpiry();
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(@Nullable T value) {
        Object object = this.loadingLock;
        synchronized (object) {
            this.value = value;
            this.lastUpdated = Instant.now();
        }
    }

    public static <T> StoredDataHolder<T> ofValue(DataType<T> type, UUID playerId, T value) {
        return new StoredDataHolder<T>(type, playerId, value);
    }

    public static <T> StoredDataHolder<T> load(DataType<T> type, UUID playerId) {
        StoredDataHolder<T> value = new StoredDataHolder<T>(type, playerId);
        value.reload();
        return value;
    }

    public T or(T defaultValue) {
        if (this.isLoading() || this.value == null) {
            return defaultValue;
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkExpiry() {
        Object object = this.loadingLock;
        synchronized (object) {
            if (this.isLoading()) {
                return;
            }
        }
        if (this.lastUpdated.isBefore(Instant.now().minus(DataSyncAPI.CACHE_DURATION))) {
            this.reload();
        }
    }

    public CompletableFuture<Optional<T>> asFuture() {
        this.checkExpiry();
        CompletableFuture<T> loader = this.loaderFuture;
        if (loader != null) {
            return loader.thenApply(Optional::ofNullable);
        }
        return CompletableFuture.completedFuture(Optional.ofNullable(this.value));
    }
}

